<?php

namespace App\Modules\QuestionTypeProvider\Application\Delete;

use App\Modules\QuestionTypeProvider\Application\Delete\QuestionTypeProviderDeleterResponse;
use App\Modules\QuestionTypeProvider\Domain\IdQuestionTypeProvider;
use App\Modules\QuestionTypeProvider\Domain\QuestionTypeProviderRepository;

final class QuestionTypeProviderDeleter
{
    public function __construct(private QuestionTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdQuestionTypeProvider $idQuestionTypeProvider): QuestionTypeProviderDeleterResponse
    {
        return new QuestionTypeProviderDeleterResponse($this->repository->delete($idQuestionTypeProvider));
    }
}
