<?php

namespace App\Modules\ProviderSanction\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ProviderSanctionUpdaterQuery implements Query
{
    public function __construct(
        private int $id,
        private string $remark,
        private string $dateStart,
        private string $dateEnd,
        private int $status,
        private int $idProvider
    ) {
    }
    
    public function id(): string
    {
        return $this->id;
    }
    
    public function remark(): string
    {
        return $this->remark;
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function dateEnd(): string
    {
        return $this->dateEnd;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idProvider(): int
    {
        return $this->idProvider;
    }
}
