<?php

namespace App\Modules\Provider\Infrastructure;

class ProviderValidators
{
    public static function insert()
    {
        return [
            'Provider_BusinessName'     => 'required|string|max:250',
            'Provider_TradeName'        => 'required|string|max:250',
            'Provider_NickName'         => 'required|string|max:250',
            'Provider_NoDocument'       => 'required|string|max:50',
            'Provider_Address'          => 'required|string|max:250',
            'Provider_Phone'            => 'required|string|max:30',
            'Provider_ImgProfile'       => 'image|mimes:' . config("var.MIME_IMG"),
            'Provider_Status'           => 'required|int',
            'Id_TypeDocument'           => 'required|int',
            'Id_TypeProvider'           => 'required|int',
            'Id_Country'                => 'required|int',
            'Id_State'                  => 'required|int',
            'Id_City'                   => 'required|int'
        ];
    }

    public static function update()
    {
        return [
            'Id_Provider'               => 'required|int',
            'Provider_BusinessName'     => 'required|string|max:250',
            'Provider_TradeName'        => 'required|string|max:250',
            'Provider_NickName'         => 'required|string|max:250',
            'Provider_NoDocument'       => 'required|string|max:50',
            'Provider_Address'          => 'required|string|max:250',
            'Provider_Phone'            => 'required|string|max:30',
            'Provider_ImgProfile'       => 'image|mimes:' . config("var.MIME_IMG"),
            'Provider_Status'           => 'required|int',
            'Id_TypeDocument'           => 'required|int',
            'Id_TypeProvider'           => 'required|int',
            'Id_Country'                => 'required|int',
            'Id_State'                  => 'required|int',
            'Id_City'                   => 'required|int'
        ];
    }
}
