<?php

namespace App\Modules\Provider\Application\Index;

use App\Modules\Provider\Application\Index\ProviderIndexerResponse;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Provider\Domain\ProviderRepository;

final class ProviderIndexer
{
    public function __construct(private ProviderRepository $repository)
    {
    }

    public function __invoke(IdProvider $idProvider): ProviderIndexerResponse
    {
        return new ProviderIndexerResponse($this->repository->index($idProvider));
    }
}
