<?php

namespace App\Modules\PaxInformationPassenger\Application;

use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRepository;
use App\Modules\PaxInformationPassenger\Domain\IdPaxInformationPassenger;

class PaxInformationPassengerFinder {

    private PaxInformationPassengerRepository $repository;

    public function __construct(PaxInformationPassengerRepository $repository) {
        $this->repository = $repository;
    }

    public function __invoke (IdPaxInformation $idPaxInformation, string $action) {
        return $this->repository->find($idPaxInformation, $action);
    }
}