<?php

namespace App\Modules\PaxInformation\Application;

use App\Modules\PaxInformation\Domain\IdPaxInformation;
use App\Modules\PaxInformation\Domain\PaxInformationSearchTokenRepository;
use App\Modules\PaxInformation\Domain\PaxInformationToken;
use App\Modules\PaxInformationPassenger\Domain\PaxInformationPassengerRepository;

class PaxInformationTokenFinder {

    private PaxInformationSearchTokenRepository $repository;
    private PaxInformationPassengerRepository $passengerRepository;

    public function __construct(
        PaxInformationSearchTokenRepository $repository,
        PaxInformationPassengerRepository $passengerRepository
    ) {
        $this->repository = $repository;
        $this->passengerRepository = $passengerRepository;
    }

    public function __invoke (PaxInformationToken $token)
    {
        $token = $this->repository->findToken($token);
        foreach ($token['Response_Data'] as $data) {
            $data->PaxInformationPassenger = $this->passengerRepository->find(new IdPaxInformation($data->Id_PaxInformation), 'all')['Response_Data'];
        }
        return $token;
    }
}