<?php

namespace App\Modules\Passenger\Application\ReviewReport;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class PassengerReviewReportQueryHandler implements QueryHandler
{
    public function __construct(private PassengerReviewReporter $reporter)
    {
    }

    public function __invoke(PassengerReviewReportQuery $query): PassengerReviewReportResponse
    {
        return $this->reporter->__invoke(
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd()),
            $query->range(),
            $query->uploadedMediaStatus(),
            $query->action()
        );
    }
}
