<?php

namespace App\Modules\Passenger\Application\Index;

use App\Modules\Passenger\Domain\IdPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class PassengerIndexerQueryHandler implements QueryHandler
{
    public function __construct(private PassengerIndexer $inserter)
    {
    }

    public function __invoke(PassengerIndexerQuery $query): PassengerIndexerResponse
    {
        return $this->inserter->__invoke(new IdPassenger($query->getId()));
    }
}
