<?php

namespace App\Modules\Passenger\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class PassengerInserterQuery implements Query
{
    public function __construct(
        private string $name,
        private string $lastName,
        private string $email,
        private string $phoneCode,
        private string $phone,
        private int $gender,
        private string $dob,
        private string $noDocument,
        private string $restriction,
        private string $extras,
        private string $imgDocument1,
        private int $reportable,
        private int $status,
        private int $infoStatus,
        private int $idBooking,
        private int $idTypeDocument,
        private int $idUserCountry,
        private int $idTypeRate
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }
    public function lastName(): string
    {
        return $this->lastName;
    }
    public function email(): string
    {
        return $this->email;
    }
    public function phoneCode(): string
    {
        return $this->phoneCode;
    }
    public function phone(): string
    {
        return $this->phone;
    }
    public function gender(): int
    {
        return $this->gender;
    }
    public function dob(): string
    {
        return $this->dob;
    }
    public function noDocument(): string
    {
        return $this->noDocument;
    }
    public function restriction(): string
    {
        return $this->restriction;
    }
    public function extras(): string
    {
        return $this->extras;
    }
    public function imgDocument1(): string
    {
        return $this->imgDocument1;
    }
    public function reportable(): int
    {
        return $this->reportable;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function infoStatus(): int
    {
        return $this->infoStatus;
    }
    public function idBooking(): int
    {
        return $this->idBooking;
    }
    public function idTypeDocument(): int
    {
        return $this->idTypeDocument;
    }
    public function idUserCountry(): int
    {
        return $this->idUserCountry;
    }
    public function idTypeRate(): int
    {
        return $this->idTypeRate;
    }
}
