<?php

namespace App\Modules\PackageFee\Infrastructure;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\PackageFee\Domain\PackageFeeRepository;
use App\Modules\Shared\Application\SelectHandler;
use Illuminate\Support\Facades\DB;

class MysqlPackageFeeRepository implements PackageFeeRepository
{
    public function list(IdPackage $idPackage): array
    {
        return (new SelectHandler())->handle(
            DB::select(
                'CALL `sp_package_fee_list`(?)',
                [
                    $idPackage->value(),
                ]
            )
        );
    }
}
