<?php

namespace App\Modules\PackageFee\Domain;

use App\Modules\Shared\Domain\Criteria\CallbackSpecification;
use App\Modules\Shared\Domain\Criteria\CriteriaContainer;
use App\Modules\Shared\Domain\Criteria\Specify;

class PackageFeeFullCriteria extends CriteriaContainer
{
    public function __construct(
        private $packageFeeFull = 2
    ) {
        parent::__construct(new Specify(new CallbackSpecification(fn ($pf) => $pf->PackageFee_Full === $this->packageFeeFull)));
    }
}
