<?php

namespace App\Modules\PackageFee\Application\GetFull;

use App\Modules\Shared\Domain\Bus\Query\Response;

final class PackageFeeGetFullQueryResponse implements Response
{
    public function __construct(
        private int $packageFeeTotal,
        private int $packageFeeType
    ) {
    }

    public function packageFeeTotal()
    {
        return $this->packageFeeTotal;
    }

    public function packageFeeType()
    {
        return $this->packageFeeType;
    }

}
