<?php
namespace App\Modules\Modules\Domain\Structure;

use App\Modules\Shared\Domain\GenerateActionException;

class ParamModuleVarchar extends ParamModule
{
    public function __construct(
        private string $key,
        private int $maxLength,
        private $defaultValue
    ) {
        parent::__construct($key, 'varchar');
    }

    public function ensureIsValid($value)
    {
        if ($this->maxLength < 0) {
            return $value;
        }
        if (strlen($value) > $this->maxLength) {
            (new GenerateActionException)("Invalid value for varchar: $value");
        }
        return $value;
    }

    public function defaultValue()
    {
        return $this->defaultValue;
    }
}
