<?php

namespace App\Modules\ModuleNotificationParam\Domain;

use App\Modules\ModuleNotification\Domain\IdModuleNotification;
use App\Modules\Modules\Domain\Structure\ModuleGroup;

class BookingConfirmationNotificationParam
{

    /** constructor */
    public function __construct(
        private string $bookingTourDateStart
    ) {
    }

    public function __invoke(IdModuleNotification $id) {
        $module = new ModuleGroup();
        $params = InsertModuleNotificationParam::fromModule($id, $module);
        $params['Query']->setValue('');
        $params['Status']->setValue(0);
        $params['DateStart']->setValue($this->bookingTourDateStart);
        $params['Range']->setValue(0);
        $params['DateEnd']->setValue($this->bookingTourDateStart);
        $params['ShowTransfer']->setValue(0);
        return $params;
    }
}
