<?php

namespace App\Modules\Media\Application\Create;

use App\Modules\Media\Domain\Media;
use App\Modules\Media\Domain\MediaHasLarge;
use App\Modules\Media\Domain\MediaInputName;
use App\Modules\Media\Domain\MediaInputStore;
use App\Modules\Media\Domain\MediaSaveConfiguration;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class CreateMediaQueryHandler implements QueryHandler
{

    public const THUMBNAIL_WIDTH = 200;
    public const THUMBNAIL_HEIGHT = 200;

    public const LARGE_THUMBNAIL_WIDTH = 1290;
    public const LARGE_THUMBNAIL_HEIGHT = 1132;

    public function __construct(private MediaCreator $creator)
    {
    }

    public function __invoke(CreateMediaQuery $query): CreateMediaResponse
    {
        $config = new MediaSaveConfiguration(
            self::THUMBNAIL_WIDTH,
            self::THUMBNAIL_HEIGHT,
            self::THUMBNAIL_WIDTH,
            self::THUMBNAIL_HEIGHT,
            true
        );
        $model = new Media(
            new MediaInputName($query->inputName()),
            new MediaInputStore($query->storagePath()),
            new MediaHasLarge(
                $query->hasLarge()
                    ? MediaHasLarge::VALUE_TRUE
                    : MediaHasLarge::VALUE_FALSE
            ),
        );
        $mediaData = $this->creator->__invoke($model);
        return new CreateMediaResponse(
            $mediaData->getThumbnail(),
            $mediaData->getLargeThumbnail(),
            $mediaData->getUrl(),
            $mediaData->getExtension(),
            $mediaData->getFilesize(),
            $mediaData->getMediaType(),
        );
    }
}
