<?php

namespace App\Modules\Machupicchu\Application\AvailabilityList;

use App\Modules\Machupicchu\Domain\Availability\Availability;
use App\Modules\Machupicchu\Domain\Availability\MachupicchuAvailabilityRepository;

final class MachupicchuAvailabilityLister
{
    public function __construct(private MachupicchuAvailabilityRepository $repository)
    {
    }

    public function __invoke(string $year, int $idRuta, int $month): MachupicchuAvailabilitiesResponse
    {
        return new MachupicchuAvailabilitiesResponse(
            ...array_map($this->toResponse(), $this->repository->find($year, $idRuta, $month))
        );
    }

    private function toResponse(): callable
    {
        return static fn(Availability $availability) => new MachupicchuAvailabilityResponse(
            $availability->capacity()->value(),
            $availability->day()->value(),
            $availability->availability()->value(),
            $availability->date()->value(),
            $availability->datePrint()->value(),
            $availability->holiday()->value(),
            $availability->route()->value()
        );
    }
}
