<?php

namespace App\Modules\LeadPassenger\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadPassenger\Domain\LeadPassenger;
use App\Modules\LeadPassenger\Domain\LeadPassengerRepository;
use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadPassengerRepository implements LeadPassengerRepository
{

    public function find(IdLeadBooking $idLeadBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_passenger_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function index(IdLeadPassenger $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_passenger_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadPassenger $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_passenger_insert(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getEmail()->value(),
                $value->getPhone()->value(),
                $value->getGender()->value(),
                $value->getDOB()->value(),
                $value->getNoDocument()->value(),
                $value->getRestriction()->value(),
                $value->getExtras()->value(),
                $value->getImgDocument1()->value(),
                $value->getStatus()->value(),
                $value->getInfoStatus()->value(),
                $value->getIdLeadBooking()->value(),
                $value->getIdTypeDocument()->value(),
                $value->getIdUserCountry()->value(),
                $value->getIdTypeRate()->value(),
            ]
        );
    }

    public function update(LeadPassenger $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_passenger_update(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getName()->value(),
                $value->getLastName()->value(),
                $value->getEmail()->value(),
                $value->getPhone()->value(),
                $value->getGender()->value(),
                $value->getDOB()->value(),
                $value->getNoDocument()->value(),
                $value->getRestriction()->value(),
                $value->getExtras()->value(),
                $value->getImgDocument1()->value(),
                $value->getStatus()->value(),
                $value->getInfoStatus()->value(),
                $value->getIdLeadBooking()->value(),
                $value->getIdTypeDocument()->value(),
                $value->getIdUserCountry()->value(),
                $value->getIdTypeRate()->value(),
            ]
        );
    }

    public function delete(IdLeadPassenger $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_passenger_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
