<?php

namespace App\Modules\LeadPassenger\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\TypeRate\Domain\IdTypeRate;
use App\Modules\UserCountry\Domain\IdUserCountry;

class LeadPassenger
{

    /** constructor */
    public function __construct(
        private LeadPassengerName $name,
        private LeadPassengerLastName $lastName,
        private LeadPassengerEmail $email,
        private LeadPassengerPhone $phone,
        private LeadPassengerGender $gender,
        private LeadPassengerDOB $dob,
        private LeadPassengerNoDocument $noDocument,
        private LeadPassengerRestriction $restriction,
        private LeadPassengerExtras $extras,
        private LeadPassengerImgDocument1 $imgDocument1,
        private LeadPassengerStatus $status,
        private LeadPassengerInfoStatus $infoStatus,
        private IdLeadBooking $idLeadBooking,
        private IdTypeDocument $idTypeDocument,
        private IdUserCountry $idUserCountry,
        private IdTypeRate $idTypeRate,
        private ?IdLeadPassenger $id = null
    ) {
    }
    
    public function getDate(): LeadPassengerDate
    {
        return $this->date;
    }
    public function getName(): LeadPassengerName
    {
        return $this->name;
    }
    public function getLastName(): LeadPassengerLastName
    {
        return $this->lastName;
    }
    public function getEmail(): LeadPassengerEmail
    {
        return $this->email;
    }
    public function getPhone(): LeadPassengerPhone
    {
        return $this->phone;
    }
    public function getGender(): LeadPassengerGender
    {
        return $this->gender;
    }
    public function getDOB(): LeadPassengerDOB
    {
        return $this->dob;
    }
    public function getNoDocument(): LeadPassengerNoDocument
    {
        return $this->noDocument;
    }
    public function getRestriction(): LeadPassengerRestriction
    {
        return $this->restriction;
    }
    public function getExtras(): LeadPassengerExtras
    {
        return $this->extras;
    }
    public function getImgDocument1(): LeadPassengerImgDocument1
    {
        return $this->imgDocument1;
    }
    public function getInfoStatus(): LeadPassengerInfoStatus
    {
        return $this->infoStatus;
    }
    public function getStatus(): LeadPassengerStatus
    {
        return $this->status;
    }
    public function getIdLeadBooking(): IdLeadBooking
    {
        return $this->idLeadBooking;
    }
    public function getIdTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }
    public function getIdUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function getIdTypeRate(): IdTypeRate
    {
        return $this->idTypeRate;
    }
    public function getId(): IdLeadPassenger
    {
        return $this->id;
    }
}
