<?php

namespace App\Modules\LeadPassenger\Application\Index;

use App\Modules\LeadPassenger\Domain\IdLeadPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadPassengerIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadPassengerIndexer $inserter)
    {
    }

    public function __invoke(LeadPassengerIndexerQuery $query): LeadPassengerIndexerResponse
    {
        return $this->inserter->__invoke(new IdLeadPassenger($query->getId()));
    }
}
