<?php

namespace App\Modules\LeadBookingTour\Application\UpdateDate;

use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourDateStart;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateDateLeadBookingTourQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourUpdater $updater)
    {
    }

    public function __invoke(UpdateDateLeadBookingTourQuery $query): UpdateDateLeadBookingTourResponse
    {
        return $this->updater->__invoke(
            new IdLeadBookingTour($query->getId()),
            new LeadBookingTourDateStart($query->getDateStart())
        );
    }
}
