<?php

namespace App\Modules\LeadBookingTour\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingTourListerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourLister $inserter)
    {
    }

    public function __invoke(LeadBookingTourListerQuery $query): LeadBookingTourListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBooking($query->getIdLeadBooking()),
            $query->getAction()
        );
    }
}
