<?php

namespace App\Modules\LeadBookingTour\Application\GroupList;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGroup;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;

final class LeadBookingTourGroupLister
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(
        IdLeadBooking $idLeadBooking,
        LeadBookingTourGroup $group,
        string $action
    ): LeadBookingTourGroupListerResponse {
        return new LeadBookingTourGroupListerResponse($this->repository->findByGroup($idLeadBooking, $group, $action));
    }
}
