<?php

namespace App\Modules\LeadBookingTour\Application\Create;

use App\Modules\LeadBookingTour\Application\Create\LeadBookingTourInserterResponse;
use App\Modules\LeadBookingTour\Domain\LeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourRepository;

final class LeadBookingTourInserter
{
    public function __construct(private LeadBookingTourRepository $repository)
    {
    }

    public function __invoke(LeadBookingTour $leadBookingTour): LeadBookingTourInserterResponse
    {
        return new LeadBookingTourInserterResponse($this->repository->insert($leadBookingTour));
    }
}
