<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Update;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingServicePassenger\Domain\IdLeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerStatus;
use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServicePassengerUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServicePassengerUpdater $updater)
    {
    }

    public function __invoke(LeadBookingServicePassengerUpdaterQuery $query): LeadBookingServicePassengerUpdaterResponse
    {
        $model = new LeadBookingServicePassenger(
            new LeadBookingServicePassengerStatus($query->getStatus()),
            new IdLeadBookingService($query->getIdLeadBookingService()),
            new IdLeadBookingTourPassenger($query->getIdLeadBookingTourPassenger()),
            new IdLeadBookingServicePassenger($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
