<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingServicePassengerUpdaterQuery implements Query
{
    public function __construct(
        private string $id,
        private int $status,
        private int $idLeadBookingService,
        private int $idLeadBookingTourPassenger
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
    public function getIdLeadBookingService(): int
    {
        return $this->idLeadBookingService;
    }
    public function getIdLeadBookingTourPassenger(): int
    {
        return $this->idLeadBookingTourPassenger;
    }
}
