<?php

namespace App\Modules\LeadBookingServicePassenger\Application\List;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingServicePassenger\Application\List\LeadBookingServicePassengerListerResponse;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;

final class LeadBookingServicePassengerLister
{
    public function __construct(private LeadBookingServicePassengerRepository $repository)
    {
    }

    public function __invoke(
        IdLeadBookingService $idLeadBookingService,
        string $action
    ): LeadBookingServicePassengerListerResponse {
        return new LeadBookingServicePassengerListerResponse($this->repository->find($idLeadBookingService, $action));
    }
}
