<?php

namespace App\Modules\LeadBookingService\Infraestructure;

use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceRepository;
use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingServiceRepository implements LeadBookingServiceRepository
{

    public function find(IdLeadBookingTour $idLeadBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_service_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function index(IdLeadBookingService $id)
    {
        return Requester::requestSelect(
            'CALL sp_lead_booking_service_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(LeadBookingService $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_service_insert(?,?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getQuantity()->value(),
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdLeadBookingTour()->value(),
                $value->getIdService()->value(),
            ]
        );
    }

    public function update(LeadBookingService $value)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_service_update(?,?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getQuantity()->value(),
                $value->getType()->value(),
                $value->getStatus()->value(),
                $value->getIdLeadBookingTour()->value(),
                $value->getIdService()->value(),
            ]
        );
    }

    public function delete(IdLeadBookingService $id)
    {
        return Requester::requestUpdate(
            'CALL sp_lead_booking_service_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
