<?php

namespace App\Modules\LeadBookingService\Application\Delete;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServiceDeleterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServiceDeleter $inserter)
    {
    }

    public function __invoke(LeadBookingServiceDeleterQuery $query): LeadBookingServiceDeleterResponse
    {
        return $this->inserter->__invoke(new IdLeadBookingService($query->getId()));
    }
}
