<?php

namespace App\Modules\LeadBookingPackage\Infrastructure;

use App\Modules\LeadBookingPackage\Domain\InsertLeadBookingPackage;
use App\Modules\LeadBookingPackage\Domain\LeadBookingPackage;
use App\Modules\LeadBookingPackage\Domain\LeadBookingPackageRepository;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlLeadBookingPackageRepository implements LeadBookingPackageRepository
{

    public function insert(InsertLeadBookingPackage $value)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_package_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->leadBookingTourDateStart()->value(),
                $value->leadBookingTourType()->value(),
                $value->idPackage()->value(),
                $value->idLeadBooking()->value()
            ]
        );
    }

    
    public function addPassengers(LeadBookingPackage $leadBookingPackage, int $passengers)
    {
        return Requester::requestInsert(
            'CALL sp_lead_booking_package_add_passengers(?,?,?,@sts,@cod,@msg)',
            [
                $passengers,
                $leadBookingPackage->leadBookingTourGroup()->value(),
                $leadBookingPackage->idLeadBooking()->value()
            ]
        );
    }
}
