<?php

namespace App\Modules\LeadBookingPackage\Application\Create;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingPackage\Domain\InsertLeadBookingPackage;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourDateStart;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourType;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class InsertLeadBookingPackageQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingPackageInserter $inserter)
    {
    }

    public function __invoke(InsertLeadBookingPackageQuery $query): InsertLeadBookingPackageResponse
    {
        $model = new InsertLeadBookingPackage(
            new LeadBookingTourDateStart($query->leadBookingTourDateStart()),
            new LeadBookingTourType($query->leadBookingTourType()),
            new IdLeadBooking($query->idLeadBooking()),
            new IdPackage($query->idPackage())
        );
        return new InsertLeadBookingPackageResponse($this->inserter->__invoke($model, $query->passengers()));
    }
}
