<?php

namespace App\Modules\LeadBooking\Application\Delete;

use App\Modules\LeadBooking\Application\Delete\LeadBookingDeleterResponse;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingRepository;

final class LeadBookingDeleter
{
    public function __construct(private LeadBookingRepository $repository)
    {
    }

    public function __invoke(IdLeadBooking $idLeadBooking): LeadBookingDeleterResponse
    {
        return new LeadBookingDeleterResponse($this->repository->delete($idLeadBooking));
    }
}
