<?php

namespace App\Modules\Image\Domain;

class Image {

    private ImageUrl $url;
    private ImageThumbUrl $thumbUrl;
    private ImageFilesize $filesize;
    private ImageExtension $extension;
    private ImageStatus $status;
    private ?IdImage $id;

    public function __construct(
        ImageUrl $url,
        ImageThumbUrl $thumbUrl,
        ImageFilesize $filesize,
        ImageExtension $extension,
        ImageStatus $status,
        ?IdImage $id = null
    )
    {
        $this->thumbUrl = $thumbUrl;
        $this->url = $url;
        $this->filesize = $filesize;
        $this->extension = $extension;
        $this->status = $status;
        $this->id = $id;
    }

    public function getUrl():ImageUrl { return $this->url; }
    public function getThumbUrl():ImageThumbUrl { return $this->thumbUrl; }
    public function getFilesize():ImageFilesize { return $this->filesize; }
    public function getExtension():ImageExtension { return $this->extension; }
    public function getStatus():ImageStatus { return $this->status; }
    public function getId():IdImage { return $this->id; }
}