<?php

namespace App\Modules\HtlTypeRoomBed\Infrastructure;

use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedRepository;
use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;
use App\Modules\Shared\Infraestructure\Requester;
use Illuminate\Support\Facades\DB;

class MysqlHtlTypeRoomBedRepository implements HtlTypeRoomBedRepository
{

    public function find(StorageCriteria $criteria): HtlTypeRoomBed | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlTypeRoomBed::fromDTO($criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn($btp) => HtlTypeRoomBed::fromDTO($btp), $criteria->run());
    }

    public function insert(HtlTypeRoomBed $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlTypeRoomBed $value)
    {
        return DBRequester::requestUpdate($value);
    }

    public function delete(IdHtlTypeRoomBed $id)
    {
        return Requester::requestUpdate(
            'CALL sp_htl_type_room_bed_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
