<?php

namespace App\Modules\HtlTypeRoomBed\Application\Update;

use App\Modules\HtlTypeRoomBed\Application\Index\HtlTypeRoomBedIndexer;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedAvailability;
use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedDescription;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedName;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateHtlTypeRoomBedQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeRoomBedUpdater $updater,
        private HtlTypeRoomBedIndexer $indexer
    ) {
    }

    public function __invoke(UpdateHtlTypeRoomBedQuery $query): UpdateHtlTypeRoomBedResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeRoomBed($query->id()), true);
        $index->setStatus(new HtlTypeRoomBedStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateHtlTypeRoomBedResponse();
    }
}
