<?php

namespace App\Modules\HtlTypeRoomBed\Application\List;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedRepository;
use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\ListHtlTypeRoomBed;

final class HtlTypeRoomBedLister
{
    public function __construct(private HtlTypeRoomBedRepository $repository)
    {
    }

    public function __invoke(IdHtlTypeRoom $idHtlTypeRoom, string $action)
    {
        return $this->repository->search(new ListHtlTypeRoomBed($idHtlTypeRoom, $action));
    }
}
