<?php

namespace App\Modules\HtlTypeRoomBed\Application\Delete;

use App\Modules\HtlTypeRoomBed\Domain\IdHtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBed;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedAbrv;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedName;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedStatus;
use App\Modules\HtlTypeRoomBed\Domain\HtlTypeRoomBedType;
use App\Modules\HtlTypeRoomBed\Domain\Id;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlRoom\Domain\IdHtlRoom;
use App\Modules\HtlTypeRoomBed\Application\Index\HtlTypeRoomBedIndexer;
use App\Modules\HtlTypeRoomBed\Application\Update\HtlTypeRoomBedUpdater;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class DeleteHtlTypeRoomBedQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlTypeRoomBedUpdater $update,
        private HtlTypeRoomBedIndexer $indexer
    ) {
    }

    public function __invoke(DeleteHtlTypeRoomBedQuery $query): DeleteHtlTypeRoomBedResponse
    {
        $index = $this->indexer->__invoke(new IdHtlTypeRoomBed($query->idHtlTypeRoomBed()), true);
        $index->delete();
        $this->update->__invoke($index);
        return new DeleteHtlTypeRoomBedResponse();
    }
}
