<?php

namespace App\Modules\HtlTypeRoom\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlTypeRoom implements StorageCriteria
{

    public function __construct(
        private IdHtlCamp $idHtlCamp,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeRoom::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`HtlTypeRoom_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`HtlTypeRoom_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`HtlTypeRoom_Status` = 0';
        } else {
            $where = '`ftd`.`HtlTypeRoom_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_type_room` `ftd`
            WHERE $where
            AND `ftd`.`Id_HtlCamp` = ?",
            [$this->idHtlCamp->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
