<?php

namespace App\Modules\HtlTypeRoom\Domain;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlTypeRoom extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlTypeRoom::class, 'Id_HtlTypeRoom', 'primary'),
            new AggregateAttribute('name', HtlTypeRoomName::class, 'HtlTypeRoom_Name'),
            new AggregateAttribute('abrv', HtlTypeRoomAbrv::class, 'HtlTypeRoom_Abrv'),
            new AggregateAttribute('status', HtlTypeRoomStatus::class, 'HtlTypeRoom_Status'),
            new AggregateAttribute('idHtlCamp', IdHtlCamp::class, 'Id_HtlCamp'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_type_room';
    }

    public function __construct(
        protected IdHtlTypeRoom $id,
        protected HtlTypeRoomName $name,
        protected HtlTypeRoomAbrv $abrv,
        protected HtlTypeRoomStatus $status,
        protected IdHtlCamp $idHtlCamp
    ) {
    }

    public function id(): IdHtlTypeRoom
    {
        return $this->id;
    }

    public function name(): HtlTypeRoomName
    {
        return $this->name;
    }

    public function abrv(): HtlTypeRoomAbrv
    {
        return $this->abrv;
    }

    public function status(): HtlTypeRoomStatus
    {
        return $this->status;
    }

    public function idHtlCamp(): IdHtlCamp
    {
        return $this->idHtlCamp;
    }

    public function setName(HtlTypeRoomName $name): void
    {
        $this->name = $name;
    }

    public function setAbrv(HtlTypeRoomAbrv $abrv): void
    {
        $this->abrv = $abrv;
    }

    public function setStatus(HtlTypeRoomStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new HtlTypeRoomStatus(HtlTypeRoomStatus::DELETED);
    }
}
