<?php

namespace App\Modules\HtlTypeRoom\Application\Index;

use App\Modules\HtlTypeRoom\Application\HtlTypeRoomResponse;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlTypeRoomQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeRoomIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlTypeRoomQuery $query): HtlTypeRoomResponse
    {
        $model = $this->inserter->__invoke(new IdHtlTypeRoom($query->getId()));
        return new HtlTypeRoomResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
            $model->idHtlCamp()->value(),
        );
    }
}
