<?php

namespace App\Modules\HtlTypeRoom\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlTypeRoomQuery implements Query
{
    public function __construct(
        private string $name,
        private string $abrv,
        private int $status,
        private int $idHtlCamp,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function abrv(): string
    {
        return $this->abrv;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }
}
