<?php

namespace App\Modules\HtlTypeCamp\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class IndexHtlTypeCamp implements StorageCriteria
{

    public function __construct(
        private IdHtlTypeCamp $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeCamp::select('`htc`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_type_camp` `htc`
            WHERE `htc`.`Id_HtlTypeCamp` = ?
            AND `htc`.`HtlTypeCamp_Status` <> 0",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlTypeCampNotFound();
        }
        return $data[0];
    }
}
