<?php

namespace App\Modules\HtlTypeCamp\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlTypeCamp extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlTypeCamp::class, 'Id_HtlTypeCamp', 'primary'),
            new AggregateAttribute('name', HtlTypeCampName::class, 'HtlTypeCamp_Name'),
            new AggregateAttribute('abrv', HtlTypeCampAbrv::class, 'HtlTypeCamp_Abrv'),
            new AggregateAttribute('status', HtlTypeCampStatus::class, 'HtlTypeCamp_Status'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_type_camp';
    }

    public function __construct(
        protected IdHtlTypeCamp $id,
        protected HtlTypeCampName $name,
        protected HtlTypeCampAbrv $abrv,
        protected HtlTypeCampStatus $status,
    ) {
    }

    public function id(): IdHtlTypeCamp
    {
        return $this->id;
    }

    public function name(): HtlTypeCampName
    {
        return $this->name;
    }

    public function abrv(): HtlTypeCampAbrv
    {
        return $this->abrv;
    }

    public function status(): HtlTypeCampStatus
    {
        return $this->status;
    }

    public function setName(HtlTypeCampName $name): void
    {
        $this->name = $name;
    }

    public function setAbrv(HtlTypeCampAbrv $abrv): void
    {
        $this->abrv = $abrv;
    }

    public function setStatus(HtlTypeCampStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new HtlTypeCampStatus(HtlTypeCampStatus::DELETED);
    }
}
