<?php

namespace App\Modules\HtlTypeCamp\Application\Index;

use App\Modules\HtlTypeCamp\Application\HtlTypeCampResponse;
use App\Modules\HtlTypeCamp\Domain\IdHtlTypeCamp;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlTypeCampQueryHandler implements QueryHandler
{
    public function __construct(private HtlTypeCampIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlTypeCampQuery $query): HtlTypeCampResponse
    {
        $model = $this->inserter->__invoke(new IdHtlTypeCamp($query->getId()));
        return new HtlTypeCampResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->abrv()->value(),
            $model->status()->value(),
        );
    }
}
