<?php

namespace App\Modules\HtlRoom\Domain;

use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;

class InsertHtlRoom
{

    private HtlRoomNumber $number;
    private HtlRoomAvailability $availability;
    private HtlRoomStatus $status;
    private IdHtlTypeRoom $idHtlTypeRoom;
    private HRIdHtlCamp $idHtlCamp;
    private ?IdHtlRoom $id;


    /** constructor */
    public function __construct(
        HtlRoomNumber $number,
        HtlRoomAvailability $availability,
        HtlRoomStatus $status,
        IdHtlTypeRoom $idHtlTypeRoom,
        HRIdHtlCamp $idHtlCamp,
        ?IdHtlRoom $id = NULL
    ) {
        $this->number = $number;
        $this->availability = $availability;
        $this->status = $status;
        $this->idHtlTypeRoom = $idHtlTypeRoom;
        $this->idHtlCamp = $idHtlCamp;
        $this->id = $id;
    }

    public function getNumber(): HtlRoomNumber
    {
        return $this->number;
    }
    public function getAvailability(): HtlRoomAvailability
    {
        return $this->availability;
    }
    public function getIdHtlTypeRoom(): IdHtlTypeRoom
    {
        return $this->idHtlTypeRoom;
    }
    public function getIdHtlCamp(): HRIdHtlCamp
    {
        return $this->idHtlCamp;
    }
    public function getStatus(): HtlRoomStatus
    {
        return $this->status;
    }
    public function getId(): IdHtlRoom
    {
        return $this->id;
    }
    public function setAvailability(HtlRoomAvailability $availability)
    {
        $this->availability = $availability;
    }
}
