<?php

namespace App\Modules\HtlCampSchedule\Application\OrderList;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class OrderListHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleListOrderer $orderer)
    {
    }

    public function __invoke(OrderListHtlCampScheduleQuery $query): OrderListHtlCampScheduleResponse
    {
        return new OrderListHtlCampScheduleResponse($this->orderer->__invoke(
            new DateTimeStart($query->getDateTimeStart()),
            new DateTimeEnd($query->getDateTimeEnd()),
            $query->getHtlCampSchedule(),
            $query->getHtlCamp(),
        ));
    }
}
