<?php

namespace App\Modules\HtlCampSchedule\Application\OrderList;

use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleRepository;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class HtlCampScheduleListOrderer
{
    private $scheduleData;
    public function __construct(private HtlCampScheduleRepository $repository)
    {
    }

    public function __invoke(
        DateTimeStart $dateStart,
        DateTimeEnd $dateEnd,
        array $scheduleList,
        object $htlCamp
    ) {
        $timeDateStart = strtotime(date('Y-m-d', strtotime($dateStart)));
        $timeDateEnd = strtotime(date('Y-m-d', strtotime($dateEnd)));
        $dayInSeconds = 86400;

        $this->scheduleData = $scheduleList;
        $dateArray = $this->createDateArray($timeDateStart, $timeDateEnd, $dayInSeconds);

        return $this->createDaysList($dateArray, $htlCamp);
    }

    private function createDaysList($dateArray, $htlCamp)
    {
        return array_map(
            fn ($curdate) => (object)[
                'date' => $curdate,
                'list' => [
                    (object)[
                        'date' => $curdate,
                        'idHtlCamp' => $htlCamp->Id_HtlCamp,
                        'availability' => $htlCamp->HtlCamp_Availability,
                        'schedule' => $this->createCampListByDay($curdate),
                        'campList' => $this->createCampListByDay($curdate)
                    ]
                ]
            ],
            $dateArray
        );
    }

    private function createCampListByDay($date)
    {
        $list = [];
        while (count($this->scheduleData) && $this->scheduleData[0]->HtlCampSchedule_DateSchedule == $date) {
            $list[] = array_shift($this->scheduleData);
        }
        return $list;
    }

    public function createDateArray(int $initial, int $to, int $sumatory)
    {
        $arr = [];
        while ($initial <= $to) {
            $arr[] = date('Y-m-d 00:00:00', $initial);
            $initial += $sumatory;
        }
        return $arr;
    }
}
