<?php

namespace App\Modules\HtlCampSchedule\Application\Order;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateTimeEnd;
use App\Modules\Shared\Domain\DateTimeStart;

final class OrderHtlCampScheduleQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampScheduleOrderer $orderer)
    {
    }

    public function __invoke(OrderHtlCampScheduleQuery $query): OrderHtlCampScheduleResponse
    {
        return new OrderHtlCampScheduleResponse($this->orderer->__invoke(
            new DateTimeStart($query->getDateTimeStart()),
            new DateTimeEnd($query->getDateTimeEnd()),
            $query->getHtlCampSchedule(),
            $query->getHtlCamp(),
        ));
    }
}
