<?php

namespace App\Modules\HtlCampSchedule\Application\Order;

class MapSchedule
{

    private $schedule;

    public function __construct(
        private array $scheduleArray
    ) {
        $this->schedule = (object)[];
        foreach ($scheduleArray as $day) {
            $this->schedule->{$day->date} = $day;
        }
    }

    public function getAvailability(string $date)
    {
        return $this->schedule->{$date}->availability;
    }
}
