<?php

namespace App\Modules\HtlCampSchedule\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlCampScheduleQuery implements Query
{
    public function __construct(
        private string $date,
        private string $dateSchedule,
        private int $fromCamp,
        private int $availability,
        private int $amountUsage,
        private int $lock,
        private int $idHtlCamp
    ) {
    }

    public function date(): string
    {
        return $this->date;
    }

    public function dateSchedule(): string
    {
        return $this->dateSchedule;
    }

    public function fromCamp(): int
    {
        return $this->fromCamp;
    }

    public function availability(): int
    {
        return $this->availability;
    }

    public function amountUsage(): int
    {
        return $this->amountUsage;
    }

    public function lock(): int
    {
        return $this->lock;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }
}
