<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ExistsHtlCampLock implements StorageCriteria
{

    public function __construct(
        private IdHtlCampLock $id,
        private bool $lockInShare = false
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampLock::select('`hcb`');

        return DB::select(
            "SELECT $select
            FROM `t_htl_camp_lock` `hcb`
            WHERE `hcb`.`Id_HtlCampLock` = ?",
            [
                $this->id->value()
            ]
        );
    }

    protected function analize($data)
    {
        if (!count($data)) {
            throw new HtlCampLockNotFound();
        }
        return $data[0];
    }
}
